***********************************************************************
*
* busybox uevent.asm -- Version 3.0 
*
* Copyright (c)
* Apple Computer, Inc.  1986-1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code which implements the main event loop
* used by the busybox program.
*
***********************************************************************

               case on

               copy 2/ainclude/e16.event
               copy 2/ainclude/e16.window
               copy busybox.equ

               mcopy macros/uevent.macros

               longi on
               longa on

***********************************************************************
* This procedure is called when an inControl message is returned
* by TaskMaster.
*
* When this routine gets control, the ID of the control that was
* hit is in TaskDATA4.  The control handle is in TaskData2 and
* the part code is in taskData 3.
*
doControls     start

               lda event+owmTaskData4   ;The ID
               cmp #ButButtonsID        ;If theID is in range...
               bcc no
               cmp #Prog6ID+1
               bcs no
               pha
               jsr openThisWindow       ;...open the window.

no             rts

               end

*********************************************************************
*
* checkFrontW
*
* This routine checks the front window to see if any changes need
* to be made to the menu items.
*
* We do this so that the edit items are only active when a desk
* accessory is active.
*
checkFrontW    start

               pha                      ;What is the front window?
               pha
               _FrontWindow
               PullLong theWindow

               lda theWindow            ;If front window is lastWindow, then
               cmp lastWindow           ;everything is already ok.
               bne doit
               ldx theWindow+2
               cpx lastWindow+2
               beq okAlready

doit           ora theWindow+2          ;If there are no windows, then
               bne atLeastOneWindow     ;everything should be disabled.
               pea $80
               pea EditMenuID
               _SetMenuFlag
               _DrawMenuBar
               jmp nowOk

atLeastOneWindow pha
               pushlong theWindow
               _GetSysWFlag
               ldx #$FF7F               ;Assume system window (desk-accessory).
               pla
               bne aa                   ;It is a system window.
               ldx #$80                 ;It is one of ours.
aa             phx
               pea EditMenuID
               _SetMenuFlag
               _DrawMenuBar

nowOk          lda theWindow
               sta lastWindow
               lda theWindow+2
               sta lastWindow+2

okAlready      rts

theWindow      dc i4'0'

lastWindow     entry
               dc i4'0'

               end

*************************************************************************
*
* mainEvent
*
* This is the main part of the program.  The program cycles in this
* loop until the user choose select.
*
mainEvent      start

               stz quitFlag             ;quitFlag flag will be set by QuitItem.
               stz lastWindow           ;Init this for checkFrontW
               stz lastWindow+2

loop           jsr checkFrontW

               pha                      ;Call TaskMaster
               pea $FFFF
               pushlong #event
               _TaskMaster
               pla

               cmp #wInGoAway
               bne aa
               jsr doCloseTop
               jmp zz

aa             cmp #wInSpecial
               beq a0
               cmp #wInMenuBar
               bne b

a0             jsr doMenu
               jmp zz

b              cmp #wInControl
               bne zz
               jsr doControls

zz             lda quitFlag
               beq loop

               rts

               end
